---
title: Stable-Diffusion API Usage Guide
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# Stable-Diffusion API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the Stable-Diffusion API, A latent text-to-image diffusion model capable of generating photo-realistic images given any text input.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
    "prompt": "an astronaut riding a horse on mars, hd, dramatic lighting",
    "scheduler": "K_EULER",
    "num_outputs": 1,
    "guidance_scale": 7.5,
    "num_inference_steps": 50
  }
};
```

```js
const data = {
   input:{
      "prompt": "multicolor hyperspace",
      "num_outputs": "1",
      "guidance_scale": 7.5,
      "num_inference_steps": 50
    }
};
```

```js
const data = {
   input: {
      "prompt": "a gentleman otter in a 19th century portrait",
      "num_outputs": 1,
      "guidance_scale": 7.5,
      "num_inference_steps": 100
    }
};
```

```js
const data = {
   input:{
      "width": 512,
      "height": 512,
      "prompt": "eye",
      "num_outputs": "1",
      "guidance_scale": 7.5,
      "num_inference_steps": 50
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/stable-diffusion@stability-ai", data, price);
    // Handle response
    console.log("Stable-Diffusion result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `prompt` String,Provide the prompt required for model inference
- `scheduler` String,Enum:[]
- `num_outputs` Number,Number of images to generate.
- `guidance_scale` Number,Scale for classifier-free guidance
- `num_inference_steps` Number,Number of denoising steps
- `height` Number,Height of generated image in pixels. Needs to be a multiple of 64
- `width` Number,Width of generated image in pixels. Needs to be a multiple of 64
- `negative_prompt` String,Specify things to not see in the output
- `seed` Number,Random seed. Leave blank to randomize the seed

### Notes

- Ensure that the provided image URL is publicly accessible and of good quality to achieve the best recognition results.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling image samples of others.

### Example Response

The API response will contain the URL of the generated cloned voice or other relevant information. Parse and use the response data according to the actual API documentation.
